"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isBoolean_1 = __importDefault(require("lodash/isBoolean"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObject_1 = __importDefault(require("./PDFObject"));
var PDFBoolean = /** @class */ (function (_super) {
    __extends(PDFBoolean, _super);
    function PDFBoolean(bool) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return PDFBoolean.fromBool(_this.boolean); };
        _this.toString = function () { return _this.boolean.toString(); };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(bool, isBoolean_1.default, 'Can only construct PDFBooleans from Booleans');
        _this.boolean = bool;
        return _this;
    }
    PDFBoolean.fromBool = function (bool) { return new PDFBoolean(bool); };
    PDFBoolean.fromString = function (boolStr) { return new PDFBoolean(utils_1.toBoolean(boolStr)); };
    return PDFBoolean;
}(PDFObject_1.default));
exports.default = PDFBoolean;
