"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var add_1 = __importDefault(require("lodash/add"));
var forEach_1 = __importDefault(require("lodash/forEach"));
var isNil_1 = __importDefault(require("lodash/isNil"));
var isPlainObject_1 = __importDefault(require("lodash/isPlainObject"));
var isString_1 = __importDefault(require("lodash/isString"));
var pdf_objects_1 = require("../pdf-objects");
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObjectIndex_1 = __importDefault(require("../pdf-document/PDFObjectIndex"));
var PDFObject_1 = __importDefault(require("./PDFObject"));
var PDFDictionary = /** @class */ (function (_super) {
    __extends(PDFDictionary, _super);
    function PDFDictionary(object, index, validKeys) {
        var _this = _super.call(this) || this;
        _this.filter = function (predicate) {
            return Array.from(_this.map.entries()).filter(function (_a) {
                var key = _a[0], val = _a[1];
                return predicate(val, key);
            });
        };
        _this.getMaybe = function (key) {
            validate_1.validate(key, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'PDFDictionary.set() requires keys to be strings or PDFNames');
            var keyName = key instanceof pdf_objects_1.PDFName ? key : pdf_objects_1.PDFName.from(key);
            return _this.map.get(keyName);
        };
        _this.get = function (key) {
            return _this.getMaybe(key) || utils_1.error("Missing PDFDictionary entry \"" + key + "\".");
        };
        _this.set = function (key, val, validateKeys) {
            if (validateKeys === void 0) { validateKeys = true; }
            validate_1.validate(key, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'PDFDictionary.set() requires keys to be strings or PDFNames');
            validate_1.validate(val, validate_1.isInstance(PDFObject_1.default), 'PDFDictionary.set() requires values to be PDFObjects');
            var keyName = key instanceof pdf_objects_1.PDFName ? key : pdf_objects_1.PDFName.from(key);
            if (validateKeys &&
                _this.validKeys &&
                !_this.validKeys.includes(keyName.key)) {
                utils_1.error("Invalid key: \"" + keyName.key + "\"");
            }
            _this.map.set(keyName, val);
            return _this;
        };
        _this.delete = function (key) {
            validate_1.validate(key, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'PDFDictionary.set() requires keys to be strings or PDFNames');
            var keyName = key instanceof pdf_objects_1.PDFName ? key : pdf_objects_1.PDFName.from(key);
            _this.map.delete(keyName);
            return _this;
        };
        _this.clone = function () { return PDFDictionary.from(new Map(_this.map), _this.index); };
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return utils_1.arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return 3 + // "<<\n"
                Array.from(_this.map.entries())
                    .map(function (_a) {
                    var key = _a[0], val = _a[1];
                    var keySize = (key.toString() + " ").length;
                    if (val instanceof pdf_objects_1.PDFIndirectObject) {
                        return keySize + val.toReference().length + 1;
                    }
                    else if (val instanceof PDFObject_1.default) {
                        return keySize + val.bytesSize() + 1;
                    }
                    throw new Error("Not a PDFObject: " + val.constructor.name);
                })
                    .reduce(add_1.default, 0) +
                2;
        }; // ">>"
        _this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer('<<\n', buffer);
            _this.map.forEach(function (val, key) {
                remaining = utils_1.addStringToBuffer(key.toString() + " ", remaining);
                if (val instanceof pdf_objects_1.PDFIndirectObject) {
                    remaining = utils_1.addStringToBuffer(val.toReference(), remaining);
                }
                else if (val instanceof PDFObject_1.default) {
                    remaining = val.copyBytesInto(remaining);
                }
                else {
                    throw new Error("Not a PDFObject: " + val.constructor.name);
                }
                remaining = utils_1.addStringToBuffer('\n', remaining);
            });
            remaining = utils_1.addStringToBuffer('>>', remaining);
            return remaining;
        };
        validate_1.validate(object, utils_1.and(utils_1.not(isNil_1.default), utils_1.or(isPlainObject_1.default, validate_1.isInstance(Map))), 'PDFDictionary can only be constructed from an Object or a Map');
        validate_1.validate(index, validate_1.isInstance(PDFObjectIndex_1.default), '"index" must be an instance of PDFObjectIndex');
        _this.index = index;
        _this.validKeys = validKeys;
        if (object instanceof Map) {
            _this.map = object;
        }
        else {
            _this.map = new Map();
            forEach_1.default(object, function (val, key) { return _this.set(key, val, false); });
        }
        return _this;
    }
    PDFDictionary.from = function (object, index) { return new PDFDictionary(object, index); };
    return PDFDictionary;
}(PDFObject_1.default));
exports.default = PDFDictionary;
