"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isString_1 = __importDefault(require("lodash/isString"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObject_1 = __importDefault(require("./PDFObject"));
// TODO: We have to support whitespace characters in hex strings when parsing,
// but maybe we should remove them when serializing?
var HEX_STRING_REGEX = /^[\dABCDEFabcdef\0\t\n\f\r ]*$/;
var PDFHexString = /** @class */ (function (_super) {
    __extends(PDFHexString, _super);
    function PDFHexString(str) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return PDFHexString.fromString(_this.string); };
        _this.toString = function () { return "<" + _this.string + ">"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(str, isString_1.default, 'PDFHexString.string must be a String');
        validate_1.validate(str, validate_1.doesMatch(HEX_STRING_REGEX), "Invalid characters in hex string: \"" + str + "\"");
        _this.string = str;
        return _this;
    }
    PDFHexString.fromString = function (str) { return new PDFHexString(str); };
    return PDFHexString;
}(PDFObject_1.default));
exports.default = PDFHexString;
