"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFIndirectReference_1 = __importDefault(require("./PDFIndirectReference"));
var PDFObject_1 = __importDefault(require("./PDFObject"));
var PDFIndirectObject = /** @class */ (function (_super) {
    __extends(PDFIndirectObject, _super);
    function PDFIndirectObject(pdfObject) {
        var _this = _super.call(this) || this;
        _this.getReference = function () { return _this.reference; };
        _this.setReferenceNumbers = function (objectNumber, generationNumber) {
            validate_1.validate(objectNumber, isNumber_1.default, 'objectNumber must be a Number');
            validate_1.validate(generationNumber, isNumber_1.default, 'generationNumber must be a Number');
            _this.reference = PDFIndirectReference_1.default.forNumbers(objectNumber, generationNumber);
            return _this;
        };
        _this.setReference = function (reference) {
            validate_1.validate(reference, validate_1.isInstance(PDFIndirectReference_1.default), '"reference" must be a PDFIndirectReference object');
            _this.reference = reference;
            return _this;
        };
        _this.toReference = function () { return _this.reference.toString(); };
        _this.clone = function () {
            return PDFIndirectObject.of(_this.pdfObject).setReference(_this.reference);
        };
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return utils_1.arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return (_this.reference.objectNumber + " " + _this.reference.generationNumber + " obj\n")
                .length +
                _this.pdfObject.bytesSize() +
                9;
        }; // "\nendobj\n\n"
        _this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer(_this.reference.objectNumber + " " + _this.reference.generationNumber + " obj\n", buffer);
            remaining = _this.pdfObject.copyBytesInto(remaining);
            remaining = utils_1.addStringToBuffer('\nendobj\n\n', remaining);
            return remaining;
        };
        validate_1.validate(pdfObject, validate_1.isInstance(PDFObject_1.default), 'PDFIndirectObject.pdfObject must be of type PDFObject');
        _this.pdfObject = pdfObject;
        return _this;
    }
    PDFIndirectObject.of = function (pdfObject) {
        return new PDFIndirectObject(pdfObject);
    };
    return PDFIndirectObject;
}(PDFObject_1.default));
exports.default = PDFIndirectObject;
