"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObject_1 = __importDefault(require("./PDFObject"));
// const pdfIndirectRefEnforcer = Symbol('PDF_INDIRECT_REF_ENFORCER');
// Using a Symbol is ideal here, but React Native doesn't current support them,
// so we'll use a string instead.
var pdfIndirectRefEnforcer = '@@__PDF_INDIRECT_REF_ENFORCER';
var pdfIndirectRefPool = new Map();
// TODO: Need to error out if obj or gen numbers are manually set!
// tslint:disable-next-line:no-unused-variable
var PDFIndirectReference = /** @class */ (function (_super) {
    __extends(PDFIndirectReference, _super);
    function PDFIndirectReference(enforcer, objectNumber, generationNumber) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return _this; };
        _this.toString = function () { return _this.objectNumber + " " + _this.generationNumber + " R"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(enforcer, validate_1.isIdentity(pdfIndirectRefEnforcer), 'Cannot create PDFIndirectReference via constructor. Use PDFIndirectReference.forNumbers instead.');
        validate_1.validate(objectNumber, isNumber_1.default, 'objectNumber must be a Number');
        validate_1.validate(generationNumber, isNumber_1.default, 'generationNumber must be a Number');
        _this.objectNumber = objectNumber;
        _this.generationNumber = generationNumber;
        return _this;
    }
    PDFIndirectReference.forNumbers = function (objectNumber, generationNumber) {
        var key = objectNumber + " " + generationNumber;
        var indirectRef = pdfIndirectRefPool.get(key);
        if (!indirectRef) {
            indirectRef = new PDFIndirectReference(pdfIndirectRefEnforcer, objectNumber, generationNumber);
            pdfIndirectRefPool.set(key, indirectRef);
        }
        return indirectRef;
    };
    return PDFIndirectReference;
}(PDFObject_1.default));
exports.default = PDFIndirectReference;
