"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isString_1 = __importDefault(require("lodash/isString"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObject_1 = __importDefault(require("./PDFObject"));
// const pdfNameEnforcer = Symbol('PDF_NAME_ENFORCER');
// Using a Symbol is ideal here, but React Native doesn't current support them,
// so we'll use a string instead.
var pdfNameEnforcer = '@@__PDF_NAME_ENFORCER';
var pdfNamePool = new Map();
var PDFName = /** @class */ (function (_super) {
    __extends(PDFName, _super);
    function PDFName(enforcer, key) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return _this; };
        _this.toString = function () {
            return ("/" + _this.key)
                .replace('#', '#23')
                .split('')
                .map(function (char) {
                return PDFName.isRegularChar(char)
                    ? char
                    : "#" + utils_1.toHexString(utils_1.toCharCode(char));
            })
                .join('');
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(enforcer, validate_1.isIdentity(pdfNameEnforcer), 'Cannot create PDFName via constructor. Use PDFName.from instead.');
        validate_1.validate(key.charAt(0), utils_1.and(validate_1.isNotIdentity(' '), validate_1.isNotIdentity('/')), 'PDFName objects may not begin with a space or slash character.');
        _this.key = key;
        return _this;
    }
    PDFName.isRegularChar = function (char) {
        return utils_1.toCharCode(char) >= utils_1.toCharCode('!') && utils_1.toCharCode(char) <= utils_1.toCharCode('~');
    };
    PDFName.from = function (str) {
        validate_1.validate(str, isString_1.default, 'PDFName.from() requires string as argument');
        var pdfName = pdfNamePool.get(str);
        if (!pdfName) {
            pdfName = new PDFName(pdfNameEnforcer, str);
            pdfNamePool.set(str, pdfName);
        }
        return pdfName;
    };
    PDFName.fromEncoded = function (str) {
        validate_1.validate(str, isString_1.default, 'PDFName.fromEncoded() requires string as argument');
        var decoded = str.replace(/(#\d{2})/g, function (match) {
            return String.fromCharCode(parseInt(match.slice(1), 16));
        });
        return PDFName.from(decoded);
    };
    return PDFName;
}(PDFObject_1.default));
exports.default = PDFName;
