"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isFinite_1 = __importDefault(require("lodash/isFinite"));
var isString_1 = __importDefault(require("lodash/isString"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObject_1 = __importDefault(require("./PDFObject"));
var PDFNumber = /** @class */ (function (_super) {
    __extends(PDFNumber, _super);
    function PDFNumber(num) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return PDFNumber.fromNumber(_this.number); };
        _this.toString = function () { return _this.number.toString(); };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(num, isFinite_1.default, 'Can only construct PDFNumbers from Numbers');
        _this.number = num;
        return _this;
    }
    PDFNumber.fromNumber = function (num) { return new PDFNumber(num); };
    PDFNumber.fromString = function (numberStr) {
        validate_1.validate(numberStr, isString_1.default, 'PDFNumber.fromString requires a string as a parameter.');
        return new PDFNumber(Number(numberStr));
    };
    return PDFNumber;
}(PDFObject_1.default));
exports.default = PDFNumber;
