"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../pdf-objects");
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFStream = /** @class */ (function (_super) {
    __extends(PDFStream, _super);
    function PDFStream(dictionary) {
        var _this = _super.call(this) || this;
        _this.validateDictionary = function () {
            if (!_this.dictionary.getMaybe('Length')) {
                utils_1.error('"Length" is a required field for PDFStream dictionaries');
            }
        };
        _this.clone = function () { return utils_1.error('"clone" is not implemented on PDFStream.'); };
        validate_1.validate(dictionary, validate_1.isInstance(pdf_objects_1.PDFDictionary), 'PDFStream.dictionary must be of type PDFDictionary');
        _this.dictionary = dictionary;
        return _this;
    }
    return PDFStream;
}(pdf_objects_1.PDFObject));
exports.default = PDFStream;
