"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable new-cap */
var isString_1 = __importDefault(require("lodash/isString"));
var pdf_objects_1 = require("../pdf-objects");
var PDFOperator_1 = __importDefault(require("../pdf-operators/PDFOperator"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
/**
 * Draws the XObject with the given name in the current Page's Resource dictionary.
 */
var Do = /** @class */ (function (_super) {
    __extends(Do, _super);
    function Do(name) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.name + " Do\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(name, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'Do operator arg "name" must be a string or PDFName.');
        _this.name = isString_1.default(name) ? pdf_objects_1.PDFName.from(name) : name;
        return _this;
    }
    Do.of = function (name) { return new Do(name); };
    return Do;
}(PDFOperator_1.default));
exports.default = Do;
