"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var isString_1 = __importDefault(require("lodash/isString"));
var pdf_objects_1 = require("../../../pdf-objects");
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the current colour space to use for stroking operations. The operand name
 * shall be a name object. If the colour space is one that can be specified by a
 * name and no additional parameters (DeviceGray, DeviceRGB, DeviceCMYK, and
 * certain cases of Pattern), the name may be specified directly. Otherwise, it
 * shall be a name defined in the ColorSpace subdictionary of the current resource
 * dictionary; the associated value shall be an array describing the colour space.
 *
 * The names DeviceGray, DeviceRGB, DeviceCMYK, and Pattern always identify the
 * corresponding colour spaces directly; they never refer to resources in the
 * ColorSpace subdictionary.
 *
 * The CS operator shall also set the current stroking colour to its initial value,
 * which depends on the colour space:
 *
 * In a DeviceGray, DeviceRGB, CalGray, or CalRGB colour space, the initial colour
 * shall have all components equal to 0.0.
 *
 * In a DeviceCMYK colour space, the initial colour shall be [0.0 0.0 0.0 1.0].
 *
 * In a Lab or ICCBased colour space, the initial colour shall have all components
 * equal to 0.0 unless that falls outside the intervals specified by the space’s
 * Range entry, in which case the nearest valid value shall be substituted.
 *
 * In an Indexed colour space, the initial colour value shall be 0.
 *
 * In a Separation or DeviceN colour space, the initial tint value shall be 1.0 for
 * all colorants.
 *
 * In a Pattern colour space, the initial colour shall be a pattern object that
 * causes nothing to be painted.
 */
var CS = /** @class */ (function (_super) {
    __extends(CS, _super);
    function CS(name) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.name + " CS\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(name, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'CS operator arg "name" must be a string or PDFName.');
        _this.name = isString_1.default(name) ? pdf_objects_1.PDFName.from(name) : name;
        return _this;
    }
    CS.of = function (name) { return new CS(name); };
    return CS;
}(PDFOperator_1.default));
exports.CS = CS;
/**
 * Same as CS but used for nonstroking operations.
 */
var cs = /** @class */ (function (_super) {
    __extends(cs, _super);
    function cs(name) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.name + " cs\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(name, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'cs operator arg "name" must be a string or PDFName.');
        _this.name = isString_1.default(name) ? pdf_objects_1.PDFName.from(name) : name;
        return _this;
    }
    cs.of = function (name) { return new cs(name); };
    return cs;
}(PDFOperator_1.default));
exports.cs = cs;
