"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the stroking colour space to DeviceGray (or the DefaultGray colour space)
 * and set the gray level to use for stroking operations. gray shall be a number
 * between 0.0 (black) and 1.0 (white).
 */
var G = /** @class */ (function (_super) {
    __extends(G, _super);
    function G(gray) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.gray + " G\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(gray, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'G operator arg "gray" must be a number between 0.0 and 1.0.');
        _this.gray = gray;
        return _this;
    }
    G.of = function (gray) { return new G(gray); };
    return G;
}(PDFOperator_1.default));
exports.G = G;
/**
 * Same as G but used for nonstroking operations.
 */
var g = /** @class */ (function (_super) {
    __extends(g, _super);
    function g(gray) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.gray + " g\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(gray, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'g operator arg "gray" must be a number between 0.0 and 1.0.');
        _this.gray = gray;
        return _this;
    }
    g.of = function (gray) { return new g(gray); };
    return g;
}(PDFOperator_1.default));
exports.g = g;
