import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the stroking colour space to DeviceCMYK (or the DefaultCMYK colour space and
 * set the colour to use for stroking operations. Each operand shall be a number
 * between 0.0 (zero concentration) and 1.0 (maximum concentration). The behaviour
 * of this operator is affected by the overprint mode.
 */
export declare class K extends PDFOperator {
    static of: (c: number, m: number, y: number, k: number) => K;
    c: number;
    y: number;
    m: number;
    k: number;
    constructor(c: number, m: number, y: number, k: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Same as K but used for nonstroking operations.
 */
export declare class k extends PDFOperator {
    static of: (c: number, m: number, y: number, key: number) => k;
    c: number;
    y: number;
    m: number;
    k: number;
    constructor(c: number, m: number, y: number, key: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
