"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name no-shadowed-variable */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the stroking colour space to DeviceCMYK (or the DefaultCMYK colour space and
 * set the colour to use for stroking operations. Each operand shall be a number
 * between 0.0 (zero concentration) and 1.0 (maximum concentration). The behaviour
 * of this operator is affected by the overprint mode.
 */
var K = /** @class */ (function (_super) {
    __extends(K, _super);
    function K(c, m, y, k) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.c + " " + _this.m + " " + _this.y + " " + _this.k + " K\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(c, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'K operator arg "c" must be a number between 0.0 and 1.0.');
        validate_1.validate(m, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'K operator arg "m" must be a number between 0.0 and 1.0.');
        validate_1.validate(y, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'K operator arg "y" must be a number between 0.0 and 1.0.');
        validate_1.validate(k, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'K operator arg "k" must be a number between 0.0 and 1.0.');
        _this.c = c;
        _this.m = m;
        _this.y = y;
        _this.k = k;
        return _this;
    }
    K.of = function (c, m, y, k) { return new K(c, m, y, k); };
    return K;
}(PDFOperator_1.default));
exports.K = K;
/**
 * Same as K but used for nonstroking operations.
 */
var k = /** @class */ (function (_super) {
    __extends(k, _super);
    function k(c, m, y, key) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.c + " " + _this.m + " " + _this.y + " " + _this.k + " k\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(c, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'k operator arg "c" must be a number between 0.0 and 1.0.');
        validate_1.validate(m, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'k operator arg "m" must be a number between 0.0 and 1.0.');
        validate_1.validate(y, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'k operator arg "y" must be a number between 0.0 and 1.0.');
        validate_1.validate(key, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'k operator arg "k" must be a number between 0.0 and 1.0.');
        _this.c = c;
        _this.m = m;
        _this.y = y;
        _this.k = key;
        return _this;
    }
    k.of = function (c, m, y, key) {
        return new k(c, m, y, key);
    };
    return k;
}(PDFOperator_1.default));
exports.k = k;
