"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the stroking colour space to DeviceRGB (or the DefaultRGB colour space) and
 * set the colour to use for stroking operations. Each operand shall be a number
 * between 0.0 (minimum intensity) and 1.0 (maximum intensity).
 */
var RG = /** @class */ (function (_super) {
    __extends(RG, _super);
    function RG(r, g, b) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.r + " " + _this.g + " " + _this.b + " RG\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(r, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'RG operator arg "r" must be a number between 0.0 and 1.0.');
        validate_1.validate(g, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'RG operator arg "g" must be a number between 0.0 and 1.0.');
        validate_1.validate(b, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'RG operator arg "b" must be a number between 0.0 and 1.0.');
        _this.r = r;
        _this.g = g;
        _this.b = b;
        return _this;
    }
    RG.of = function (r, g, b) { return new RG(r, g, b); };
    return RG;
}(PDFOperator_1.default));
exports.RG = RG;
/**
 * Same as RG but used for nonstroking operations.
 */
var rg = /** @class */ (function (_super) {
    __extends(rg, _super);
    function rg(r, g, b) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.r + " " + _this.g + " " + _this.b + " rg\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(r, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'rg operator arg "r" must be a number between 0.0 and 1.0.');
        validate_1.validate(g, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'rg operator arg "g" must be a number between 0.0 and 1.0.');
        validate_1.validate(b, utils_1.and(validate_1.isNumber, validate_1.isInRange(0.0, 1.0)), 'rg operator arg "b" must be a number between 0.0 and 1.0.');
        _this.r = r;
        _this.g = g;
        _this.b = b;
        return _this;
    }
    rg.of = function (r, g, b) { return new rg(r, g, b); };
    return rg;
}(PDFOperator_1.default));
exports.rg = rg;
