"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var isNil_1 = __importDefault(require("lodash/isNil"));
var isString_1 = __importDefault(require("lodash/isString"));
var pdf_objects_1 = require("../../../pdf-objects");
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Same as SC but also supports Pattern, Separation, DeviceN and ICCBased colour
 * spaces.
 *
 * If the current stroking colour space is a Separation, DeviceN, or ICCBased
 * colour space, the operands c1...cn shall be numbers. The number of operands and
 * their interpretation depends on the colour space.
 *
 * If the current stroking colour space is a Pattern colour space, name shall be
 * the name of an entry in the Pattern subdictionary of the current resource
 * dictionary. For an uncoloured tiling pattern
 * (PatternType = 1 and PaintType = 2), c1...cn
 * shall be component values specifying a colour in the pattern’s underlying colour
 * space. For other types of patterns, these operands shall not be specified.
 */
var SCN = /** @class */ (function (_super) {
    __extends(SCN, _super);
    // TODO: Confirm whether or not a number[] and string will ever both be present?
    function SCN(c, name) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.name
                ? _this.c.join(' ') + " " + _this.name + " SCN\n"
                : _this.c.join(' ') + " SCN\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validateArr(c, validate_1.isNumber, 'SCN operator args "c" must be all be numbers.');
        validate_1.validate(name, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName), isNil_1.default), 'SCN operator arg "name" must be a string or PDFName.');
        _this.c = c;
        _this.name = isString_1.default(name) ? pdf_objects_1.PDFName.from(name) : name;
        return _this;
    }
    SCN.of = function (c, name) { return new SCN(c, name); };
    return SCN;
}(PDFOperator_1.default));
exports.SCN = SCN;
/**
 * Same as SCN but used for nonstroking operations.
 */
var scn = /** @class */ (function (_super) {
    __extends(scn, _super);
    function scn(c, name) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.name
                ? _this.c.join(' ') + " " + _this.name + " scn\n"
                : _this.c.join(' ') + " scn\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validateArr(c, validate_1.isNumber, 'scn operator args "c" must be all be numbers.');
        validate_1.validate(name, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName), isNil_1.default), 'scn operator arg "name" must be a string or PDFName.');
        _this.c = c;
        _this.name = isString_1.default(name) ? pdf_objects_1.PDFName.from(name) : name;
        return _this;
    }
    scn.of = function (c, name) { return new scn(c, name); };
    return scn;
}(PDFOperator_1.default));
exports.scn = scn;
