import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the colour to use for stroking operations in a device, CIE-based
 * (other than ICCBased), or Indexed colour space. The number of operands required
 * and their interpretation depends on the current stroking colour space:
 *
 * For DeviceGray, CalGray, and Indexed colour spaces, one operand shall be
 * required (n = 1).
 *
 * For DeviceRGB, CalRGB, and Lab colour spaces, three operands shall be
 * required (n = 3).
 *
 * For DeviceCMYK, four operands shall be required (n = 4).
 */
export declare class SC extends PDFOperator {
    static of: (...c: number[]) => SC;
    c: [number, number, number, number];
    constructor(...c: number[]);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Same as SC but used for nonstroking operations.
 */
export declare class sc extends PDFOperator {
    static of: (...c: number[]) => sc;
    c: [number, number, number, number];
    constructor(...c: number[]);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
