"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var isNil_1 = __importDefault(require("lodash/isNil"));
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the colour to use for stroking operations in a device, CIE-based
 * (other than ICCBased), or Indexed colour space. The number of operands required
 * and their interpretation depends on the current stroking colour space:
 *
 * For DeviceGray, CalGray, and Indexed colour spaces, one operand shall be
 * required (n = 1).
 *
 * For DeviceRGB, CalRGB, and Lab colour spaces, three operands shall be
 * required (n = 3).
 *
 * For DeviceCMYK, four operands shall be required (n = 4).
 */
var SC = /** @class */ (function (_super) {
    __extends(SC, _super);
    // TODO: The number of operands required here depends on the current
    // color space. So shouldn't really be restricting it to just 4 numbers.
    function SC() {
        var c = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            c[_i] = arguments[_i];
        }
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.c.join(' ') + " SC\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(c[0], validate_1.isNumber, 'SC operator args "c" must be a number.');
        validate_1.validate(c[1], utils_1.or(validate_1.isNumber, isNil_1.default), 'SC operator args "c" must be a number.');
        validate_1.validate(c[2], utils_1.or(validate_1.isNumber, isNil_1.default), 'SC operator args "c" must be a number.');
        validate_1.validate(c[3], utils_1.or(validate_1.isNumber, isNil_1.default), 'SC operator args "c" must be a number.');
        _this.c = c;
        return _this;
    }
    SC.of = function () {
        var c = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            c[_i] = arguments[_i];
        }
        return new (SC.bind.apply(SC, [void 0].concat(c)))();
    };
    return SC;
}(PDFOperator_1.default));
exports.SC = SC;
/**
 * Same as SC but used for nonstroking operations.
 */
var sc = /** @class */ (function (_super) {
    __extends(sc, _super);
    // TODO: The number of operands required here depends on the current
    // color space. So shouldn't really be restricting it to just 4 numbers.
    function sc() {
        var c = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            c[_i] = arguments[_i];
        }
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.c.join(' ') + " sc\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(c[0], validate_1.isNumber, 'sc operator args "c" must be a number.');
        validate_1.validate(c[1], utils_1.or(validate_1.isNumber, isNil_1.default), 'sc operator args "c" must be a number.');
        validate_1.validate(c[2], utils_1.or(validate_1.isNumber, isNil_1.default), 'sc operator args "c" must be a number.');
        validate_1.validate(c[3], utils_1.or(validate_1.isNumber, isNil_1.default), 'sc operator args "c" must be a number.');
        _this.c = c;
        return _this;
    }
    sc.of = function () {
        var c = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            c[_i] = arguments[_i];
        }
        return new (sc.bind.apply(sc, [void 0].concat(c)))();
    };
    return sc;
}(PDFOperator_1.default));
exports.sc = sc;
