"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the line cap style in the graphics state
 */
var J = /** @class */ (function (_super) {
    __extends(J, _super);
    function J(lineCap) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.lineCap + " J\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(lineCap, validate_1.oneOf(0, 1, 2), 'J operator arg "lineCap" must be 0, 1, or 2.');
        _this.lineCap = lineCap;
        return _this;
    }
    J.of = function (lineCap) { return new J(lineCap); };
    return J;
}(PDFOperator_1.default));
exports.J = J;
/**
 * Set the line join style in the graphics state
 */
var j = /** @class */ (function (_super) {
    __extends(j, _super);
    function j(lineJoin) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.lineJoin + " j\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(lineJoin, validate_1.oneOf(0, 1, 2), 'j operator arg "lineJoin" must be 0, 1, or 2.');
        _this.lineJoin = lineJoin;
        return _this;
    }
    j.of = function (lineJoin) { return new j(lineJoin); };
    return j;
}(PDFOperator_1.default));
exports.j = j;
