"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var isString_1 = __importDefault(require("lodash/isString"));
var pdf_objects_1 = require("../../../pdf-objects");
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the specified parameters in the graphics state.
 * dictName shall be the name of a graphics state parameter dictionary in the
 *  ExtGState subdictionary of the current resource dictionary.
 */
var gs = /** @class */ (function (_super) {
    __extends(gs, _super);
    function gs(dictName) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.dictName + " gs\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(dictName, isString_1.default, 'gs operator arg "dictName" must be a string or PDFName.');
        _this.dictName = isString_1.default(dictName) ? pdf_objects_1.PDFName.from(dictName) : dictName;
        return _this;
    }
    gs.of = function (dictName) { return new gs(dictName); };
    return gs;
}(PDFOperator_1.default));
exports.default = gs;
