"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the flatness tolerance in the graphics state.
 * flatness is a number in the * range 0 to 100; a value of 0 shall specify the
 *   output device’s default flatness tolerance.
 */
var i = /** @class */ (function (_super) {
    __extends(i, _super);
    function i(flatness) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.flatness + " i\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(flatness, validate_1.isInRange(0, 100), 'i operator arg "flatness" must be a number from 0 to 100.');
        _this.flatness = flatness;
        return _this;
    }
    i.of = function (flatness) { return new i(flatness); };
    return i;
}(PDFOperator_1.default));
exports.default = i;
