import PDFOperator from '../../../pdf-operators/PDFOperator';
export declare type RenderingIntents = '/AbsoluteColorimetric' | '/RelativeColorimetric' | '/Saturation' | '/Perceptual';
/**
 * Set the colour rendering intent in the graphics state. The rendering intent
 * must be one of the following values:
 *  - AbsoluteColorimetric
 *  - RelativeColorimetric
 *  - Saturation
 *  - Perceptual
 */
declare class ri extends PDFOperator {
    static of: (intent: RenderingIntents) => ri;
    intent: RenderingIntents;
    constructor(intent: RenderingIntents);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default ri;
