"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * (lowercase L) Append a straight line segment from the current point to the
 *   point (x, y).
 * The new current point shall be (x, y).
 */
var l = /** @class */ (function (_super) {
    __extends(l, _super);
    function l(x, y) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.x + " " + _this.y + " l\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(x, validate_1.isNumber, 'l operator arg "x" must be a number.');
        validate_1.validate(y, validate_1.isNumber, 'l operator arg "y" must be a number.');
        _this.x = x;
        _this.y = y;
        return _this;
    }
    l.of = function (x, y) { return new l(x, y); };
    return l;
}(PDFOperator_1.default));
exports.default = l;
