"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Begin a new subpath by moving the current point to coordinates (x, y),
 *  omitting any connecting line segment.
 * If the previous path construction operator in the current path was also m,
 *  the new m overrides it; no vestige of the previous m operation remains in
 *  the path.
 */
var m = /** @class */ (function (_super) {
    __extends(m, _super);
    function m(x, y) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.x + " " + _this.y + " m\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(x, validate_1.isNumber, 'm operator arg "x" must be a number.');
        validate_1.validate(y, validate_1.isNumber, 'm operator arg "y" must be a number.');
        _this.x = x;
        _this.y = y;
        return _this;
    }
    m.of = function (x, y) { return new m(x, y); };
    return m;
}(PDFOperator_1.default));
exports.default = m;
