import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Append a rectangle to the current path as a complete subpath, with lower-left
 *   corner (x, y) and dimensions width and height in user space.
 * The operation `x y width height re` is equivalent to
 * ```
 * x y m
 * (x + width) y l
 * (x + width) (y + height) l
 * x (y + height) l
 * h
 * ```
 */
declare class re extends PDFOperator {
    static of: (x: number, y: number, width: number, height: number) => re;
    x: number;
    y: number;
    width: number;
    height: number;
    constructor(x: number, y: number, width: number, height: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default re;
