"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Append a rectangle to the current path as a complete subpath, with lower-left
 *   corner (x, y) and dimensions width and height in user space.
 * The operation `x y width height re` is equivalent to
 * ```
 * x y m
 * (x + width) y l
 * (x + width) (y + height) l
 * x (y + height) l
 * h
 * ```
 */
var re = /** @class */ (function (_super) {
    __extends(re, _super);
    function re(x, y, width, height) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.x + " " + _this.y + " " + _this.width + " " + _this.height + " re\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(x, validate_1.isNumber, 're operator arg "x" must be a number.');
        validate_1.validate(y, validate_1.isNumber, 're operator arg "y" must be a number.');
        validate_1.validate(width, validate_1.isNumber, 're operator arg "width" must be a number.');
        validate_1.validate(height, validate_1.isNumber, 're operator arg "height" must be a number.');
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    re.of = function (x, y, width, height) {
        return new re(x, y, width, height);
    };
    return re;
}(PDFOperator_1.default));
exports.default = re;
