"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Append a cubic Bézier curve to the current path.
 * The curve shall extend from the current point to the point (x3, y3), using
 *  the current point and (x2, y2) as the Bézier control points.
 * The new current point shall be (x3, y3).
 */
var v = /** @class */ (function (_super) {
    __extends(v, _super);
    function v(x2, y2, x3, y3) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.x2 + " " + _this.y2 + " " + _this.x3 + " " + _this.y3 + " v\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validateArr([x2, y2, x3, y3], validate_1.isNumber, 'v operator args "x2 y2 x3 y3" must all be numbers.');
        _this.x2 = x2;
        _this.y2 = y2;
        _this.x3 = x3;
        _this.y3 = y3;
        return _this;
    }
    v.of = function (x2, y2, x3, y3) {
        return new v(x2, y2, x3, y3);
    };
    return v;
}(PDFOperator_1.default));
exports.default = v;
