import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Append a cubic Bézier curve to the current path.
 * The curve shall extend from the current point to the point (x3, y3),
 *  using (x1, y1) and (x3, y3) as the Bézier control points.
 * The new current point shall be (x3, y3).
 */
declare class y extends PDFOperator {
    static of: (x1: number, y1: number, x3: number, y3: number) => y;
    x1: number;
    y1: number;
    x3: number;
    y3: number;
    constructor(x1: number, y1: number, x3: number, y3: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default y;
