import { IPDFOperatorSingleton } from '../../../pdf-operators/PDFOperator';
/**
 * Stroke the path.
 */
export declare const S: IPDFOperatorSingleton;
/**
 * Close and stroke the path. This operator shall have the same effect as the sequence h S.
 */
export declare const s: IPDFOperatorSingleton;
/**
 * Fill the path, using the nonzero winding number rule to determine the region
 * to fill. Any subpaths that are open shall be implicitly closed before being
 * filled.
 */
export declare const f: IPDFOperatorSingleton;
/**
 * Equivalent to f; included only for compatibility. Although PDF reader
 * applications shall be able to accept this operator, PDF writer applications
 * should use f instead.
 */
export declare const F: IPDFOperatorSingleton;
/**
 * Fill and then stroke the path, using the nonzero winding number rule to
 * determine the region to fill. This operator shall produce the same result as
 * constructing two identical path objects, painting the first with f and the
 * second with S.
 * NOTE: The filling and stroking portions of the operation consult different
 * values of several graphics state parameters, such as the current colour.
 */
export declare const B: IPDFOperatorSingleton;
/**
 * Close, fill, and then stroke the path, using the nonzero winding number rule
 * to determine the region to fill. This operator shall have the same effect as
 * the sequence h B.
 */
export declare const b: IPDFOperatorSingleton;
/**
 * End the path object without filling or stroking it. This operator shall be a
 * path-painting no-op, used primarily for the side effect of changing the
 * current clipping path
 */
export declare const n: IPDFOperatorSingleton;
