"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
/**
 * Stroke the path.
 */
exports.S = PDFOperator_1.default.createSingletonOp('S');
/**
 * Close and stroke the path. This operator shall have the same effect as the sequence h S.
 */
exports.s = PDFOperator_1.default.createSingletonOp('s');
/**
 * Fill the path, using the nonzero winding number rule to determine the region
 * to fill. Any subpaths that are open shall be implicitly closed before being
 * filled.
 */
exports.f = PDFOperator_1.default.createSingletonOp('f');
/**
 * Fill the path, using the even-odd rule to determine the region to fill.
 */
exports.f.asterisk = PDFOperator_1.default.createSingletonOp('f*');
/**
 * Equivalent to f; included only for compatibility. Although PDF reader
 * applications shall be able to accept this operator, PDF writer applications
 * should use f instead.
 */
exports.F = PDFOperator_1.default.createSingletonOp('F');
/**
 * Fill and then stroke the path, using the nonzero winding number rule to
 * determine the region to fill. This operator shall produce the same result as
 * constructing two identical path objects, painting the first with f and the
 * second with S.
 * NOTE: The filling and stroking portions of the operation consult different
 * values of several graphics state parameters, such as the current colour.
 */
exports.B = PDFOperator_1.default.createSingletonOp('B');
/**
 * Fill and then stroke the path, using the even-odd rule to determine the
 * region to fill. This operator shall produce the same result as B, except
 * that the path is filled as if with f* instead of f.
 */
exports.B.asterisk = PDFOperator_1.default.createSingletonOp('B*');
/**
 * Close, fill, and then stroke the path, using the nonzero winding number rule
 * to determine the region to fill. This operator shall have the same effect as
 * the sequence h B.
 */
exports.b = PDFOperator_1.default.createSingletonOp('b');
/**
 * Close, fill, and then stroke the path, using the even-odd rule to determine
 * the region to fill. This operator shall have the same effect as
 * the sequence h B*.
 */
exports.b.asterisk = PDFOperator_1.default.createSingletonOp('b*');
/**
 * End the path object without filling or stroking it. This operator shall be a
 * path-painting no-op, used primarily for the side effect of changing the
 * current clipping path
 */
exports.n = PDFOperator_1.default.createSingletonOp('n');
