import { IPDFOperatorSingleton } from '../pdf-operators/PDFOperator';
import { CS, cs } from './graphics/color/CSOps';
import { G, g } from './graphics/color/GOps';
import { K, k } from './graphics/color/KOps';
import { RG, rg } from './graphics/color/RGOps';
import { SCN, scn } from './graphics/color/SCNOps';
import { SC, sc } from './graphics/color/SCOps';
import cm from './graphics/graphics-state/cm';
import d from './graphics/graphics-state/d';
import gs from './graphics/graphics-state/gs';
import i from './graphics/graphics-state/i';
import { J, j } from './graphics/graphics-state/JOps';
import M from './graphics/graphics-state/M';
import ri from './graphics/graphics-state/ri';
import w from './graphics/graphics-state/w';
import c from './graphics/path-construction/c';
import l from './graphics/path-construction/l';
import m from './graphics/path-construction/m';
import re from './graphics/path-construction/re';
import v from './graphics/path-construction/v';
import y from './graphics/path-construction/y';
import { TD, Td } from './text/text-positioning/TDOps';
import Tm from './text/text-positioning/Tm';
import { DoubleQuote, SingleQuote } from './text/text-showing/QuoteOps';
import { TJ, Tj } from './text/text-showing/TJOps';
import Tc from './text/text-state/Tc';
import Tf from './text/text-state/Tf';
import TL from './text/text-state/TL';
import Tr from './text/text-state/Tr';
import Ts from './text/text-state/Ts';
import Tw from './text/text-state/Tw';
import Tz from './text/text-state/Tz';
import Do from './Do';
export declare const generalGraphicsStateOperators: (typeof d | typeof gs | typeof i | typeof J | typeof j | typeof M | typeof ri | typeof w)[];
export declare const colorOperators: (typeof CS | typeof G | typeof K | typeof RG | typeof SCN | typeof SC)[];
export declare const textStateOperators: (typeof Tc | typeof Tf | typeof TL | typeof Tr | typeof Ts | typeof Tw | typeof Tz)[];
export declare const textShowingOperators: (typeof SingleQuote | typeof DoubleQuote | typeof TJ)[];
export declare const textPositioningOperators: (IPDFOperatorSingleton | typeof Td | typeof Tm)[];
declare const PDFOperators: {
    T: {
        asterisk: IPDFOperatorSingleton;
    };
    TD: typeof TD;
    Td: typeof Td;
    Tm: typeof Tm;
    quote: {
        single: typeof SingleQuote;
        double: typeof DoubleQuote;
    };
    TJ: typeof TJ;
    Tj: typeof Tj;
    Tc: typeof Tc;
    Tf: typeof Tf;
    TL: typeof TL;
    Tr: typeof Tr;
    Ts: typeof Ts;
    Tw: typeof Tw;
    Tz: typeof Tz;
    Do: typeof Do;
    S: IPDFOperatorSingleton;
    s: IPDFOperatorSingleton;
    f: IPDFOperatorSingleton;
    F: IPDFOperatorSingleton;
    B: IPDFOperatorSingleton;
    b: IPDFOperatorSingleton;
    n: IPDFOperatorSingleton;
    cm: typeof cm;
    w: typeof w;
    M: typeof M;
    d: typeof d;
    ri: typeof ri;
    i: typeof i;
    gs: typeof gs;
    J: typeof J;
    j: typeof j;
    c: typeof c;
    h: IPDFOperatorSingleton;
    l: typeof l;
    m: typeof m;
    re: typeof re;
    v: typeof v;
    y: typeof y;
    q: IPDFOperatorSingleton;
    Q: IPDFOperatorSingleton;
    W: IPDFOperatorSingleton;
    CS: typeof CS;
    cs: typeof cs;
    SC: typeof SC;
    sc: typeof sc;
    SCN: typeof SCN;
    scn: typeof scn;
    G: typeof G;
    g: typeof g;
    RG: typeof RG;
    rg: typeof rg;
    K: typeof K;
    k: typeof k;
};
export default PDFOperators;
