"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
}
Object.defineProperty(exports, "__esModule", { value: true });
var W_1 = __importDefault(require("./graphics/clipping-path/W"));
var CSOps_1 = require("./graphics/color/CSOps");
var GOps_1 = require("./graphics/color/GOps");
var KOps_1 = require("./graphics/color/KOps");
var RGOps_1 = require("./graphics/color/RGOps");
var SCNOps_1 = require("./graphics/color/SCNOps");
var SCOps_1 = require("./graphics/color/SCOps");
var cm_1 = __importDefault(require("./graphics/graphics-state/cm"));
var d_1 = __importDefault(require("./graphics/graphics-state/d"));
var gs_1 = __importDefault(require("./graphics/graphics-state/gs"));
var i_1 = __importDefault(require("./graphics/graphics-state/i"));
var JOps_1 = require("./graphics/graphics-state/JOps");
var M_1 = __importDefault(require("./graphics/graphics-state/M"));
var QOps_1 = __importDefault(require("./graphics/graphics-state/QOps"));
var ri_1 = __importDefault(require("./graphics/graphics-state/ri"));
var w_1 = __importDefault(require("./graphics/graphics-state/w"));
var c_1 = __importDefault(require("./graphics/path-construction/c"));
var h_1 = __importDefault(require("./graphics/path-construction/h"));
var l_1 = __importDefault(require("./graphics/path-construction/l"));
var m_1 = __importDefault(require("./graphics/path-construction/m"));
var re_1 = __importDefault(require("./graphics/path-construction/re"));
var v_1 = __importDefault(require("./graphics/path-construction/v"));
var y_1 = __importDefault(require("./graphics/path-construction/y"));
var pathPaintingOps = __importStar(require("../pdf-operators/graphics/path-painting"));
var T_asterisk_1 = __importDefault(require("./text/text-positioning/T-asterisk"));
var TDOps_1 = require("./text/text-positioning/TDOps");
var Tm_1 = __importDefault(require("./text/text-positioning/Tm"));
var QuoteOps_1 = require("./text/text-showing/QuoteOps");
var TJOps_1 = require("./text/text-showing/TJOps");
var Tc_1 = __importDefault(require("./text/text-state/Tc"));
var Tf_1 = __importDefault(require("./text/text-state/Tf"));
var TL_1 = __importDefault(require("./text/text-state/TL"));
var Tr_1 = __importDefault(require("./text/text-state/Tr"));
var Ts_1 = __importDefault(require("./text/text-state/Ts"));
var Tw_1 = __importDefault(require("./text/text-state/Tw"));
var Tz_1 = __importDefault(require("./text/text-state/Tz"));
var Do_1 = __importDefault(require("./Do"));
/*
 * These operator categories are defined in the
 * "Table 51 – Operator Categories" table in the PDF specification document
 */
exports.generalGraphicsStateOperators = [w_1.default, JOps_1.J, JOps_1.j, M_1.default, d_1.default, ri_1.default, i_1.default, gs_1.default];
exports.colorOperators = [CSOps_1.CS, CSOps_1.cs, SCOps_1.SC, SCNOps_1.SCN, SCOps_1.sc, SCNOps_1.scn, GOps_1.G, GOps_1.g, RGOps_1.RG, RGOps_1.rg, KOps_1.K, KOps_1.k];
exports.textStateOperators = [Tc_1.default, Tw_1.default, Tz_1.default, TL_1.default, Tf_1.default, Tr_1.default, Ts_1.default];
exports.textShowingOperators = [TJOps_1.Tj, TJOps_1.TJ, QuoteOps_1.SingleQuote, QuoteOps_1.DoubleQuote];
exports.textPositioningOperators = [TDOps_1.Td, TDOps_1.TD, Tm_1.default, T_asterisk_1.default];
// TODO: These are valid in TextObjects, but they aren't implemented in
//       pdf-lib yet.
// export const markedContentOperators =
//   [MP, DP, BMC, BDC, EMC]
var PDFOperators = __assign({ W: W_1.default,
    CS: CSOps_1.CS,
    cs: CSOps_1.cs,
    SC: SCOps_1.SC,
    sc: SCOps_1.sc,
    SCN: SCNOps_1.SCN,
    scn: SCNOps_1.scn,
    G: GOps_1.G,
    g: GOps_1.g,
    RG: RGOps_1.RG,
    rg: RGOps_1.rg,
    K: KOps_1.K,
    k: KOps_1.k }, QOps_1.default, { cm: cm_1.default,
    w: w_1.default,
    M: M_1.default,
    d: d_1.default,
    ri: ri_1.default,
    i: i_1.default,
    gs: gs_1.default,
    J: JOps_1.J,
    j: JOps_1.j,
    c: c_1.default,
    h: h_1.default,
    l: l_1.default,
    m: m_1.default,
    re: re_1.default,
    v: v_1.default,
    y: y_1.default }, pathPaintingOps, { T: { asterisk: T_asterisk_1.default }, TD: TDOps_1.TD,
    Td: TDOps_1.Td,
    Tm: Tm_1.default, quote: { single: QuoteOps_1.SingleQuote, double: QuoteOps_1.DoubleQuote }, TJ: TJOps_1.TJ,
    Tj: TJOps_1.Tj,
    Tc: Tc_1.default,
    Tf: Tf_1.default,
    TL: TL_1.default,
    Tr: Tr_1.default,
    Ts: Ts_1.default,
    Tw: Tw_1.default,
    Tz: Tz_1.default,
    Do: Do_1.default });
exports.default = PDFOperators;
