"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var add_1 = __importDefault(require("lodash/add"));
var pdf_operators_1 = require("../../pdf-operators");
var PDFOperator_1 = __importDefault(require("../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../utils");
var validate_1 = require("../../../utils/validate");
var validCategories = pdf_operators_1.colorOperators.concat(pdf_operators_1.generalGraphicsStateOperators, pdf_operators_1.textPositioningOperators, pdf_operators_1.textShowingOperators, pdf_operators_1.textStateOperators);
// TODO: Validate that only valid text operators are passed or pushed to this object.
var PDFTextObject = /** @class */ (function (_super) {
    __extends(PDFTextObject, _super);
    function PDFTextObject() {
        var operators = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            operators[_i] = arguments[_i];
        }
        var _this = _super.call(this) || this;
        _this.operatorsBytesSize = function () {
            return _this.operators
                .filter(Boolean)
                .map(function (op) { return op.bytesSize(); })
                .reduce(add_1.default, 0);
        };
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return utils_1.arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return 3 + // "BT\n"
                _this.operatorsBytesSize() +
                3;
        }; // "ET\n"
        _this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer('BT\n', buffer);
            remaining = _this.operators
                .filter(Boolean)
                .reduce(function (remBytes, op) { return op.copyBytesInto(remBytes); }, remaining);
            remaining = utils_1.addStringToBuffer('ET\n', remaining);
            return remaining;
        };
        PDFTextObject.validateOperators(operators);
        _this.operators = operators;
        return _this;
    }
    PDFTextObject.of = function () {
        var operators = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            operators[_i] = arguments[_i];
        }
        return new (PDFTextObject.bind.apply(PDFTextObject, [void 0].concat(operators)))();
    };
    PDFTextObject.validateOperators = function (elements) {
        return validate_1.validateArr(elements, function (op) {
            return validCategories.some(function (category) { return op instanceof category; });
        }, 'only PDF text operators can be pushed to a PDFTextObject');
    };
    return PDFTextObject;
}(PDFOperator_1.default));
exports.default = PDFTextObject;
