import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the text matrix, Tm, and the text line matrix, T_lm:
 *              |a b 0|
 * T_m = T_lm = |c d 0|
 *              |e f 1|
 * The operands shall all be numbers, and the initial value for Tm and Tlm shall be
 * the identity matrix, [1 0 0 1 0 0]. Although the operands specify a matrix, they
 * shall be passed to Tm as six separate numbers, not as an array. The matrix
 * specified by the operands shall not be concatenated onto the current text
 * matrix, but shall replace it.
 */
declare class Tm extends PDFOperator {
    static of: (a: number, b: number, c: number, d: number, e: number, f: number) => Tm;
    a: number;
    b: number;
    c: number;
    d: number;
    e: number;
    f: number;
    constructor(a: number, b: number, c: number, d: number, e: number, f: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default Tm;
