"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable new-cap */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the text matrix, Tm, and the text line matrix, T_lm:
 *              |a b 0|
 * T_m = T_lm = |c d 0|
 *              |e f 1|
 * The operands shall all be numbers, and the initial value for Tm and Tlm shall be
 * the identity matrix, [1 0 0 1 0 0]. Although the operands specify a matrix, they
 * shall be passed to Tm as six separate numbers, not as an array. The matrix
 * specified by the operands shall not be concatenated onto the current text
 * matrix, but shall replace it.
 */
var Tm = /** @class */ (function (_super) {
    __extends(Tm, _super);
    function Tm(a, b, c, d, e, f) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.a + " " + _this.b + " " + _this.c + " " + _this.d + " " + _this.e + " " + _this.f + " Tm\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validateArr([a, b, c, d, e, f], validate_1.isNumber, 'Tm operator args "a b c d e f" must all be numbers.');
        _this.a = a;
        _this.b = b;
        _this.c = c;
        _this.d = d;
        _this.e = e;
        _this.f = f;
        return _this;
    }
    Tm.of = function (a, b, c, d, e, f) { return new Tm(a, b, c, d, e, f); };
    return Tm;
}(PDFOperator_1.default));
exports.default = Tm;
