import { PDFHexString, PDFString } from '../../../pdf-objects/index';
import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Move to the next line and show a text string.
 * This operator shall have the same effect as the code:
 * T*
 * string Tj
 */
export declare class SingleQuote extends PDFOperator {
    static of: (str: string | PDFHexString | PDFString) => SingleQuote;
    string: PDFString | PDFHexString;
    constructor(str: PDFString | PDFHexString | string);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Move to the next line and show a text string, using aw as the word spacing
 * and ac as the character spacing (setting the corresponding parameters in the
 * text state). aw and ac shall be numbers expressed in unscaled text space units.
 * This operator shall have the same effect as this code:
 * aw Tw
 * ac Tc
 * string '
 */
export declare class DoubleQuote extends PDFOperator {
    static of: (aw: number, ac: number, str: string | PDFHexString | PDFString) => DoubleQuote;
    aw: number;
    ac: number;
    string: PDFString | PDFHexString;
    constructor(aw: number, ac: number, str: PDFString | PDFHexString | string);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
