"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var isString_1 = __importDefault(require("lodash/isString"));
var index_1 = require("../../../pdf-objects/index");
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Move to the next line and show a text string.
 * This operator shall have the same effect as the code:
 * T*
 * string Tj
 */
var SingleQuote = /** @class */ (function (_super) {
    __extends(SingleQuote, _super);
    function SingleQuote(str) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.string.toString() + " '\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(str, utils_1.or(validate_1.isInstance(index_1.PDFString), validate_1.isInstance(index_1.PDFHexString), isString_1.default), '\' operator arg "string" must be one of: PDFString, PDFHexString, String');
        _this.string = isString_1.default(str) ? index_1.PDFString.fromString(str) : str;
        return _this;
    }
    SingleQuote.of = function (str) { return new SingleQuote(str); };
    return SingleQuote;
}(PDFOperator_1.default));
exports.SingleQuote = SingleQuote;
/**
 * Move to the next line and show a text string, using aw as the word spacing
 * and ac as the character spacing (setting the corresponding parameters in the
 * text state). aw and ac shall be numbers expressed in unscaled text space units.
 * This operator shall have the same effect as this code:
 * aw Tw
 * ac Tc
 * string '
 */
var DoubleQuote = /** @class */ (function (_super) {
    __extends(DoubleQuote, _super);
    function DoubleQuote(aw, ac, str) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.aw + " " + _this.ac + " " + _this.string.toString() + " \"\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(aw, validate_1.isNumber, '" operator arg "aw" must be a Number');
        validate_1.validate(ac, validate_1.isNumber, '" operator arg "ac" must be a Number');
        validate_1.validate(str, utils_1.or(validate_1.isInstance(index_1.PDFString), validate_1.isInstance(index_1.PDFHexString), isString_1.default), '" operator arg "string" must be one of: PDFString, PDFHexString, String');
        _this.aw = aw;
        _this.ac = ac;
        _this.string = isString_1.default(str) ? index_1.PDFString.fromString(str) : str;
        return _this;
    }
    DoubleQuote.of = function (aw, ac, str) { return new DoubleQuote(aw, ac, str); };
    return DoubleQuote;
}(PDFOperator_1.default));
exports.DoubleQuote = DoubleQuote;
