"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file class-name */
var add_1 = __importDefault(require("lodash/add"));
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var isString_1 = __importDefault(require("lodash/isString"));
var index_1 = require("../../../pdf-objects/index");
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Show a text string.
 */
var Tj = /** @class */ (function (_super) {
    __extends(Tj, _super);
    function Tj(str) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.string + " Tj\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(str, utils_1.or(validate_1.isInstance(index_1.PDFString), validate_1.isInstance(index_1.PDFHexString), isString_1.default), 'Tj operator arg "str" must be one of: PDFString, PDFHexString, String');
        _this.string = isString_1.default(str) ? index_1.PDFString.fromString(str) : str;
        return _this;
    }
    Tj.of = function (str) { return new Tj(str); };
    return Tj;
}(PDFOperator_1.default));
exports.Tj = Tj;
/**
 * Show one or more text strings, allowing individual glyph positioning.
 * Each element of array shall be either a string or a number.
 * If the element is a string, this operator shall show the string.
 * If it is a number, the operator shall adjust the text position by that
 *  amount; that is, it shall translate the text matrix, Tm.
 * The number shall be expressed in thousandths of a unit of text space.
 * This amount shall be subtracted from the current horizontal or vertical
 *   coordinate, depending on the writing mode.
 * In the default coordinate system, a positive adjustment has the effect of
 * moving the next glyph painted either to the left or down by the given amount.
 */
var TJ = /** @class */ (function (_super) {
    __extends(TJ, _super);
    function TJ() {
        var array = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            array[_i] = arguments[_i];
        }
        var _this = _super.call(this) || this;
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return utils_1.arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return _this.array.map(function (elem) { return elem.bytesSize(); }).reduce(add_1.default, 0) +
                _this.array.length + // Spaces between elements
                4 + // "[ " and "]"
                3;
        }; // The "TJ" characters and trailing newline
        _this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer('[ ', buffer);
            _this.array.forEach(function (elem) {
                remaining = elem.copyBytesInto(remaining);
                remaining = utils_1.addStringToBuffer(' ', remaining);
            });
            remaining = utils_1.addStringToBuffer('] TJ\n', remaining);
            return remaining;
        };
        if (array.length === 0) {
            utils_1.error('TJ operator requires  PDFStrings, PDFHexStrings, PDFNumbers, Strings, or Numbers to be constructed');
        }
        validate_1.validateArr(array, utils_1.or(validate_1.isInstance(index_1.PDFString), validate_1.isInstance(index_1.PDFHexString), validate_1.isInstance(index_1.PDFNumber), isString_1.default, isNumber_1.default), 'TJ operator arg elements must be one of: PDFString, PDFHexString, PDFNumber, String, Number');
        // prettier-ignore
        _this.array = array.map(function (elem) {
            return isString_1.default(elem) ? index_1.PDFString.fromString(elem)
                : isNumber_1.default(elem) ? index_1.PDFNumber.fromNumber(elem)
                    : elem;
        });
        return _this;
    }
    TJ.of = function () {
        var array = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            array[_i] = arguments[_i];
        }
        return new (TJ.bind.apply(TJ, [void 0].concat(array)))();
    };
    return TJ;
}(PDFOperator_1.default));
exports.TJ = TJ;
