import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the character spacing, Tc, to charSpace, which shall be a number
 *   expressed in unscaled text space units.
 * Character spacing shall be used by the Tj, TJ, and ' operators.
 * Initial value: 0.
 */
declare class Tc extends PDFOperator {
    static of: (charSpace: number) => Tc;
    charSpace: number;
    constructor(charSpace: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default Tc;
