import { PDFName } from '../../../pdf-objects';
import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the text font, Tf, to font and the text font size, Tfs, to size. font shall
 * be the name of a font resource in the Font subdictionary of the current resource
 * dictionary; size shall be a number representing a scale factor. There is no
 * initial value for either font or size; they shall be specified explicitly by
 * using Tf before any text is shown.
 */
declare class Tf extends PDFOperator {
    static of: (font: string | PDFName, size: number) => Tf;
    font: PDFName;
    size: number;
    constructor(font: string | PDFName, size: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default Tf;
