"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable new-cap */
var isString_1 = __importDefault(require("lodash/isString"));
var pdf_objects_1 = require("../../../pdf-objects");
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the text font, Tf, to font and the text font size, Tfs, to size. font shall
 * be the name of a font resource in the Font subdictionary of the current resource
 * dictionary; size shall be a number representing a scale factor. There is no
 * initial value for either font or size; they shall be specified explicitly by
 * using Tf before any text is shown.
 */
var Tf = /** @class */ (function (_super) {
    __extends(Tf, _super);
    function Tf(font, size) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.font + " " + _this.size + " Tf\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(font, utils_1.or(isString_1.default, validate_1.isInstance(pdf_objects_1.PDFName)), 'Tf operator arg "font" must be a string or PDFName.');
        validate_1.validate(size, validate_1.isNumber, 'Tf operator arg "size" must be a number.');
        _this.font = isString_1.default(font) ? pdf_objects_1.PDFName.from(font) : font;
        _this.size = size;
        return _this;
    }
    Tf.of = function (font, size) { return new Tf(font, size); };
    return Tf;
}(PDFOperator_1.default));
exports.default = Tf;
