"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable new-cap */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the word spacing, Tw, to wordSpace, which shall be a number expressed in
 * unscaled text space units. Word spacing shall be used by the Tj, TJ, and '
 * operators. Initial value: 0.
 */
var Tw = /** @class */ (function (_super) {
    __extends(Tw, _super);
    function Tw(wordSpace) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.wordSpace + " Tw\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(wordSpace, validate_1.isNumber, 'Tw operator arg "wordSpace" must be a number.');
        _this.wordSpace = wordSpace;
        return _this;
    }
    Tw.of = function (wordSpace) { return new Tw(wordSpace); };
    return Tw;
}(PDFOperator_1.default));
exports.default = Tw;
