"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable new-cap */
var PDFOperator_1 = __importDefault(require("../../../pdf-operators/PDFOperator"));
var utils_1 = require("../../../../utils");
var validate_1 = require("../../../../utils/validate");
/**
 * Set the horizontal scaling, Th, to (scale ÷ 100). scale shall be a number
 * specifying the percentage of the normal width. Initial value: 100 (normal width).
 */
var Tz = /** @class */ (function (_super) {
    __extends(Tz, _super);
    function Tz(scale) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.scale + " Tz\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return utils_1.addStringToBuffer(_this.toString(), buffer);
        };
        validate_1.validate(scale, validate_1.isNumber, 'Tz operator arg "scale" must be a number.');
        _this.scale = scale;
        return _this;
    }
    Tz.of = function (scale) { return new Tz(scale); };
    return Tz;
}(PDFOperator_1.default));
exports.default = Tz;
