"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../../pdf-objects");
var pako_1 = __importDefault(require("pako"));
var decodeStream = function (data, _a) {
    var filter = _a.key;
    if (filter === 'FlateDecode')
        return pako_1.default.inflate(data);
    // TODO: Implement support for all other filter types
    if (filter === 'DCTDecode')
        return data;
    throw new Error("Unknown stream filter type: " + filter);
};
exports.default = (function (dict, contents) {
    var filters = dict.get('Filter');
    if (filters) {
        var filtersArr = filters instanceof pdf_objects_1.PDFArray ? filters.array : [filters];
        return filtersArr.reduce(decodeStream, contents);
    }
    return contents;
});
