import { PDFDictionary, PDFStream } from '../pdf-objects';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { PDFObjectStream } from '../pdf-structures';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Dictionary. Then checks if the subsequent characters
 * make up a PDF Stream.
 *
 * If a PDFDictionary is found, but no PDFStream, then the dictionary is returned.
 * If a PDFStream is also found, then it is instead returned. The second argument
 * of the returned tuple contains a subarray of the input with the characters
 * making up the parsed object removed.
 *
 * If no PDFDictionary is found at all, null is returned.
 */
declare const parseDictOrStream: (input: Uint8Array, index: PDFObjectIndex, parseHandlers?: IParseHandlers) => void | [PDFDictionary | PDFStream | PDFObjectStream, Uint8Array];
export default parseDictOrStream;
