import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes comprising a PDF document as input. Parses all the
 * objects in the file in a sequential fashion, beginning with the header and
 * ending with the last trailer.
 *
 * The XRef tables/streams in the input are not used to locate and parse objects
 * as needed. Rather, the whole document is parsed and stored in memory at once.
 */
declare const parseDocument: (input: Uint8Array, index: PDFObjectIndex, parseHandlers: IParseHandlers) => void;
export default parseDocument;
