"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../pdf-objects");
var utils_1 = require("../../utils");
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Hex String.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF Hex
 * String and (2) a subarray of the input with the characters making up the parsed
 * hex string removed. The "onParseHexString" parse handle will also be called with
 * the PDFHexString object.
 *
 * If not, null is returned.
 */
var parseHexString = function (input, _a) {
    var onParseHexString = (_a === void 0 ? {} : _a).onParseHexString;
    var hexStringRegex = /^<([\dABCDEFabcdef\0\t\n\f\r ]*)>/;
    var trimmed = utils_1.trimArrayAndRemoveComments(input);
    if (trimmed.length === 0)
        return undefined;
    // Search for first character that isn't part of a hex string
    var idx = 0;
    while (utils_1.charFromCode(trimmed[idx]).match(/^[<(\dABCDEFabcdef\0\t\n\f\r ]/)) {
        idx += 1;
    }
    // Try to match the regex up to that character to see if we've got a hex string
    var result = utils_1.arrayToString(trimmed, 0, idx + 2).match(hexStringRegex);
    if (!result)
        return undefined;
    var fullMatch = result[0], hexString = result[1];
    var pdfHexString = pdf_objects_1.PDFHexString.fromString(hexString);
    if (onParseHexString)
        onParseHexString(pdfHexString);
    return [pdfHexString, trimmed.subarray(fullMatch.length)];
};
exports.default = parseHexString;
