"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../pdf-objects");
var utils_1 = require("../../utils");
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Null value.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF Null
 * value and (2) a subarray of the input with the characters making up the parsed
 * null value removed. The "onParseNull" parse handler will also be called with the
 * PDFNull object.
 *
 * If not, null is returned.
 */
var parseNull = function (input, _a) {
    var onParseNull = (_a === void 0 ? {} : _a).onParseNull;
    var trimmed = utils_1.trimArrayAndRemoveComments(input);
    if (utils_1.arrayToString(trimmed, 0, 4) !== 'null')
        return undefined;
    if (onParseNull)
        onParseNull(pdf_objects_1.PDFNull.instance);
    return [pdf_objects_1.PDFNull.instance, trimmed.subarray(4)];
};
exports.default = parseNull;
