import { PDFNumber } from '../pdf-objects';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Number.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF
 * Number and (2) a subarray of the input with the characters making up the parsed
 * number removed. The "onParseNumber" parse handler will also be called with the
 * parsed PDFNumber object.
 *
 * If not, null is returned.
 */
declare const parseNumber: (input: Uint8Array, { onParseNumber }?: IParseHandlers) => void | [PDFNumber, Uint8Array];
export default parseNumber;
