import { PDFDictionary } from '../pdf-objects';
import { PDFObjectStream } from '../pdf-structures';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an a PDFDictionary and an array of bytes as input. The PDFDictionary
 * should be a PDF Object Stream dictionary, and the array of bytes should be the Object Stream's
 * content. *The array of bytes is expected to have been decoded (based on the
 * "Filter"s in the dictionary) prior to being passed to this function.*
 *
 * After parsing the integer pairs from the start of the input bytes, the objects
 * themselves will be parsed from the remaining input bytes.
 *
 * A PDFObjectStream will be returned, representing the objects parsed
 * from the Object Stream. The "onParseObjectStream" parse handler will also be
 * called with the parsed PDFObjectStream object.
 */
declare const parseObjectStream: (dict: PDFDictionary, input: Uint8Array, index: PDFObjectIndex, parseHandlers?: IParseHandlers) => PDFObjectStream;
export default parseObjectStream;
