import { PDFTrailer } from '../pdf-structures';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Trailer.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF
 * Trailer and (2) a subarray of the input with the characters making up the parsed
 * trailer removed. The "onParseTrailer" parse handler will be called with the
 * PDFTrailer object. The "onParseDict" parse handler will be called with the
 * dictionary of the PDFTrailer, and the "onParseNumber" parse handler will be
 * called with the "lastXRefOffset" of the PDFTrailer.
 *
 * If not, null is returned.
 */
declare const parseTrailer: (input: Uint8Array, index: PDFObjectIndex, parseHandlers?: IParseHandlers) => void | [PDFTrailer, Uint8Array];
/**
 * Same as "parseTrailer" function, except does not look for the complete trailer.
 * Specifically, the "trailer" keyword and the trailer's dictionary are not parsed.
 *
 * Documents that use Object Streams do not need the "trailer" keyword or the
 * associated dictionary. (The Object Streams store the trailer's dictionary.)
 */
declare const parseTrailerWithoutDict: (input: Uint8Array, index: PDFObjectIndex, parseHandlers?: IParseHandlers) => void | [PDFTrailer, Uint8Array];
export { parseTrailer, parseTrailerWithoutDict };
